import matplotlib.pyplot as plt
import matplotlib.backends.backend_tkagg as bt

def create_plot(container):

    fig, ax = plt.subplots(layout='constrained')

    canvas = bt.FigureCanvasTkAgg(fig, container)
    canvas.get_tk_widget().pack()

    return ax, canvas


def update_plot(ax, canvas, x, y, label_x, label_y,
                marker='-', clear_flag=True):

    text_size=12

    if clear_flag == True:
        ax.clear()

    ax.tick_params(axis='both', labelsize=text_size)
    ax.set_xlabel(label_x, fontsize=text_size)
    ax.set_ylabel(label_y, fontsize=text_size)
    ax.grid()

    ax.plot(x, y, marker)
    canvas.draw()

    return

if __name__ == '__main__':

    import tkinter as tk

    label_x, label_y = 'x-axis', 'y-axis'
    x, y = [], []
    root = tk.Tk()

    ax, canvas = create_plot(root)
    update_plot(ax, canvas, x, y, label_x, label_y)
